import os
import yt_dlp

def search_and_download(query, download_path='./'):
    # YouTube'da arama yap
    ydl = yt_dlp.YoutubeDL({'format': 'bestvideo+bestaudio/best'})
    results = ydl.extract_info(f"ytsearch:{query}", download=False)

    if not results['entries']:
        print(f"Aradığınız '{query}' için video bulunamadı.")
        return

    video_info = results['entries'][0]
    video_title = video_info['title']
    video_url = video_info['webpage_url']

    print(f"Bulunan video: {video_title}")
    print(f"Video URL: {video_url}")

    # Videoyu indir
    download_options = {
        'format': 'bestvideo+bestaudio/best',
        'outtmpl': os.path.join(download_path, f"{video_title}.mp4"),
    }

    with yt_dlp.YoutubeDL(download_options) as ydl:
        ydl.download([video_url])

    print("İndirme tamamlandı.")

if __name__ == "__main__":
    search_query = input("Lütfen indirmek istediğiniz video adını veya anahtar kelimeyi girin: ")
    download_folder = input("İndirilen videonun kaydedileceği klasörü girin (Varsayılan: ./): ") or './'

    search_and_download(search_query, download_folder)
