from youtubesearchpython import VideosSearch
from pytube import YouTube

def search_and_download(query, download_path='./'):
    videos_search = VideosSearch(query, limit=1)
    results = videos_search.result()

    if not results['result']:
        print(f"Aradığınız '{query}' için video bulunamadı.")
        return

    video_info = results['result'][0]
    video_title = video_info['title']
    video_url = f"https://www.youtube.com/watch?v={video_info['id']}"

    print(f"Bulunan video: {video_title}")
    print(f"Video URL: {video_url}")

    yt = YouTube(video_url)
    video_stream = yt.streams.filter(progressive=True, file_extension='mp4').first()

    if video_stream:
        print("Video indiriliyor...")
        video_stream.download(download_path)
        print("İndirme tamamlandı.")
    else:
        print("İndirilebilir bir video formatı bulunamadı.")

if __name__ == "__main__":
    search_query = input("Lütfen indirmek istediğiniz video adını veya anahtar kelimeyi girin: ")
    download_folder = input("İndirilen videonun kaydedileceği klasörü girin (Varsayılan: ./): ") or './'

    search_and_download(search_query, download_folder)
