from pytube import Playlist, YouTube

def is_playlist_url(url):
    playlist_identifiers = ['list=', 'playlist?']
    return any(identifier in url.lower() for identifier in playlist_identifiers)

def download_media(url, download_folder='C:/Programlarım/YTDown'):
    try:
        if is_playlist_url(url):
            # Oynatma listesi URL'si algılandı
            playlist = Playlist(url)
            print(f"Oynatma Listesi Başlığı: {playlist.title}")

            for video in playlist.videos:
                download_video(video, download_folder)
        else:
            # Video URL'si algılandı
            video = YouTube(url)
            download_video(video, download_folder)
    except Exception as e:
        print(f"Hata oluştu: {e}")

def download_video(video, download_folder):
    print(f"Video Başlığı: {video.title}")
    print(f"Çözünürlük: {video.streams.get_highest_resolution().resolution}")
    print(f"İndiriliyor...")

    video.streams.get_highest_resolution().download(download_folder)

    print(f"{video.title} indirme tamamlandı.\n")

if __name__ == "__main__":
    media_url = input("Lütfen indirmek istediğiniz medya (video/oynatma listesi) URL'sini girin: ")
    download_folder = input("İndirilen medyanın kaydedileceği klasörü girin (Varsayılan: ./): ") or "./"

    download_media(media_url, download_folder)
