from pytube import Playlist, YouTube

def download_media(url, download_folder):
    try:
        if 'list=' in url.lower():
            # Oynatma listesi URL'si algılandı
            playlist = Playlist(url)
            print(f"Oynatma Listesi Başlığı: {playlist.title}")

            for video in playlist.videos:
                download_video(video, download_folder)
        else:
            # Video URL'si algılandı
            video = YouTube(url)
            download_video(video, download_folder)
    except Exception as e:
        print(f"Hata oluştu: {e}")

def download_video(video, download_folder):
    print(f"Video Başlığı: {video.title}")
    print(f"Çözünürlük: {video.streams.get_highest_resolution().resolution}")
    print(f"İndiriliyor...")

    video.streams.get_highest_resolution().download(download_folder)

    print(f"{video.title} indirme tamamlandı.\n")

def get_user_input():
    media_url = input("Lütfen indirmek istediğiniz medya (video/oynatma listesi) URL'sini girin: ")
    download_folder = input("İndirilen medyanın kaydedileceği klasörü girin (Varsayılan: ./): ") or "./"
    return media_url, download_folder

if __name__ == "__main__":
    media_url, download_folder = get_user_input()
    download_media(media_url, download_folder)
